﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ComponentModel;
using AZVIC.Ei8htPOS.Utilities;
using System.Data;

namespace AZVIC.Ei8htPOS.Entities
{
    public class QuotationsDetails : BusinessBaseClass
    {

        public QuotationsDetails()
        {

        }

        public QuotationsDetails(IDataReader myDataRecord)
        {
            UniqueID = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("QuotationsDetailsID")) ? Guid.Empty : myDataRecord.GetGuid(myDataRecord.GetOrdinal("QuotationsDetailsID"));
            QuotationsID = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("QuotationsID")) ? Guid.Empty : myDataRecord.GetGuid(myDataRecord.GetOrdinal("QuotationsID"));
            ProductID = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("ProductID")) ? Guid.Empty : myDataRecord.GetGuid(myDataRecord.GetOrdinal("ProductID"));
            ProductName = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("ProductName")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("ProductName"));
            SpecialInstruction = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("SpecialInstruction")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("SpecialInstruction"));
            UnitPrice = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("UnitPrice")) ? 0 : myDataRecord.GetDecimal(myDataRecord.GetOrdinal("UnitPrice"));
            OrderPrice = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("OrderPrice")) ? 0 : myDataRecord.GetDecimal(myDataRecord.GetOrdinal("OrderPrice"));
            Quantity = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("Quantity")) ? 0 : myDataRecord.GetInt32(myDataRecord.GetOrdinal("Quantity"));
            CanApplyDiscount = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("CanApplyDiscount")) ? false : myDataRecord.GetBoolean(myDataRecord.GetOrdinal("CanApplyDiscount"));
            Amount = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("Amount")) ? 0 : myDataRecord.GetDecimal(myDataRecord.GetOrdinal("Amount"));
            Remarks = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("Remarks")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("Remarks"));
            QuotationsStatus = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("QuotationsStatus")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("QuotationsStatus"));
            IsMiscellaneous = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("IsMiscellaneous")) ? false : myDataRecord.GetBoolean(myDataRecord.GetOrdinal("IsMiscellaneous"));
            UserAccountID = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("CreatedBy")) ? Guid.Empty : myDataRecord.GetGuid(myDataRecord.GetOrdinal("CreatedBy"));
            CreatedDate = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("CreatedDate")) ? DateTime.MinValue : myDataRecord.GetDateTime(myDataRecord.GetOrdinal("CreatedDate"));
            ModifiedDate = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("ModifiedDate")) ? DateTime.MinValue : myDataRecord.GetDateTime(myDataRecord.GetOrdinal("ModifiedDate"));
            IsActive = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("IsActive")) ? false : myDataRecord.GetBoolean(myDataRecord.GetOrdinal("IsActive"));
            //IsDeleted = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("IsDeleted")) ? false : myDataRecord.GetBoolean(myDataRecord.GetOrdinal("IsDeleted"));
        }

        [DataObjectField(true, false, false)]
        public override Guid UniqueID { get; set; }

        public Guid QuotationsID { get; set; }

        public Guid ProductID { get; set; }

        public string ProductName { get; set; }

        public decimal UnitPrice { get; set; }

        public decimal OrderPrice { get; set; }

        public int Quantity { get; set; }

        public decimal Amount { get; set; }

        public string SpecialInstruction { get; set; }

        public bool CanApplyDiscount { get; set; }

        public string Remarks { get; set; }

        public string QuotationsStatus { get; set; }

        public bool IsMiscellaneous { get; set; }

        public Guid UserAccountID { get; set; }

        public override DateTime CreatedDate { get; set; }

        public override DateTime ModifiedDate { get; set; }

        public override GlobalConfigurations.Mode Mode { get; set; }

        public override bool IsActive { get; set; }

        //public override bool IsDeleted { get; set; }
    }
}
